<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
server:
  port: 8080
<#assign zuul=false>
<#if item.getAllPSDataEntities?? && item.getAllPSDataEntities()??>
    <#assign haswfentity=false>
    <#list item.getAllPSDataEntities() as appDataEntity>
        <#assign serviceId="">
        <#assign serviceUrl=srfpluralize(appDataEntity.codeName?lower_case)>
        <#assign appEntity=appDataEntity.name?lower_case>
        <#assign psDataEntity=appDataEntity>
        <#assign systemName=sys.getCodeName()?lower_case>
        <#if psDataEntity.hasPSDEWF()?? && psDataEntity.hasPSDEWF()==true>
            <#assign haswfentity=true>
        </#if>
        <#if psDataEntity.getStorageMode()==4>
            <#comment>serviceApi模式</#comment>
            <#assign serviceId=(psDataEntity.getPSSubSysServiceAPI().getServiceCodeName())!''>
            <#assign serviceUrl=srfpluralize(appDataEntity.codeName?lower_case)>
            <#if serviceId!="">
                <#assign zuul=true>
            </#if>
        </#if>
    </#list>
    <#if haswfentity==true>
        <#assign zuul=true>
    </#if>
    <#if sys.getPSSystemSetting()?? && sys.getPSSystemSetting().getDataAccCtrlArch()?? && sys.getPSSystemSetting().getDataAccCtrlArch()==1>
        <#assign zuul=true>
    </#if>
</#if>

<#if zuul==true && item.getAllPSDataEntities?? && item.getAllPSDataEntities()??>
#zuul网关路由设置
zuul:
  routes:
    <#assign haswfentity=false>
    <#list item.getAllPSDataEntities() as appDataEntity>
        <#assign serviceId="">
        <#assign serviceUrl=srfpluralize(appDataEntity.codeName?lower_case)>
        <#assign appEntity=appDataEntity.name?lower_case>
        <#assign psDataEntity=appDataEntity>
        <#assign systemName=sys.getCodeName()?lower_case>
        <#if psDataEntity.hasPSDEWF()?? && psDataEntity.hasPSDEWF()==true>
            <#assign haswfentity=true>
        </#if>
        <#if psDataEntity.getStorageMode()==4>
            <#comment>serviceApi模式</#comment>
            <#assign serviceId=(psDataEntity.getPSSubSysServiceAPI().getServiceCodeName())!''>
            <#assign serviceUrl=srfpluralize(appDataEntity.name?lower_case)>
        <#if serviceId!="">
        <#assign serviceId="$"+"{ibiz.ref.service."+serviceId?lower_case+":"+serviceId+"}">
      ${appEntity}:
        path: /${serviceUrl}/**
        serviceId: ${serviceId}
        stripPrefix: false
            </#if>
        </#if>
    </#list>
    <#if haswfentity==true>
      wfcore:
        path: /wfcore/**
        serviceId: ${r'${ibiz.ref.service.wf:ibzwf-api}'}
        stripPrefix: true
    </#if>
    <#if sys.getPSSystemSetting()?? && sys.getPSSystemSetting().getDataAccCtrlArch()?? && sys.getPSSystemSetting().getDataAccCtrlArch()==1>
      loginv7:
        path: /v7/login
        serviceId: ${r'${ibiz.ref.service.uaa:ibzuaa-api}'}
        stripPrefix: false
      changepwd:
        path: /v7/changepwd
        serviceId: ${r'${ibiz.ref.service.uaa:ibzuaa-api}'}
        stripPrefix: false
      uaa:
        path: /uaa/**
        serviceId: ${r'${ibiz.ref.service.uaa:ibzuaa-api}'}
        stripPrefix: false
      config:
        path: /config/**
        serviceId: ${r'${ibiz.ref.service.uaa:ibzuaa-api}'}
        stripPrefix: false
        <#if sys.getCodeName()!='ibzou' && sys.getCodeName()!='ibzrt'>
      oucore:
        path: /ibzorganizations/**
        serviceId: ${r'${ibiz.ref.service.ou:ibzou-api}'}
        stripPrefix: false
      oudict:
        path: /dictionarys/**/Ibzou**
        serviceId: ${r'${ibiz.ref.service.ou:ibzou-api}'}
        stripPrefix: false
      ou:
        path: /ibzdepartments/**
        serviceId: ${r'${ibiz.ref.service.ou:ibzou-api}'}
        stripPrefix: false
      uaadict:
        path: /dictionarys/**/SysOperator
        serviceId: ${r'${ibiz.ref.service.uaa:ibzuaa-api}'}
        stripPrefix: false
      dict:
        path: /dictionarys/**
        serviceId: ${r'${ibiz.ref.service.dict:ibzdict-api}'}
        stripPrefix: false
      disk:
        path: /net-disk/**
        serviceId: ${r'${ibiz.ref.service.disk:ibzdisk-api}'}
        stripPrefix: false
      ou_sys_org:
        path: /sysorganizations/**
        serviceId: ${r'${ibiz.ref.service.ou:ibzou-api}'}
        stripPrefix: false
      ou_sys_dept:
        path: /sysdepartments/**
        serviceId: ${r'${ibiz.ref.service.ou:ibzou-api}'}
        stripPrefix: false
      lite-core:
        path: /lite/**
        serviceId: ${r'${ibiz.ref.service.lite:ibzlite-api}'}
        stripPrefix: false
        </#if>
    </#if>
    <#comment>通过设置该参数，避免Zuul转发请求时丢失Authorization请求头信息</#comment>
  sensitive-headers:
    - Cookie,Set-Cookie,Authorization
</#if>